//
//  MCCAppRater.h
//  MCCloud
//
//  Created by Alykhan Jetha on 13-02-06.
//
//

#import <Foundation/Foundation.h>

extern NSString *kMCARCloudID;
extern NSString *kMCARUserUUIDKey;  // md5hash of username
extern NSString *kMCARDatabaseUUIDKey;
extern NSString *kMCARAppIdentifierKey;
extern NSString *kMCARAppVersionKey; // version (build)  1.6.2 (36511)
extern NSString *kMCARDeviceTypeKey;
extern NSString *kMCARDevicePlatformKey;
extern NSString *kMCARSystemName;
extern NSString *kMCARSystemVersion;
extern NSString *kMCARFirstUseDate;  // %Y%m%d
extern NSString *kMCARAppOrigin; // mas or download
extern NSString *kMCARLocale;

extern NSString *kMCARAskForRating;
extern NSString *kMCARRatingURL;


@class ASIHTTPRequest;

typedef void (^MCCAppRaterCallback)(BOOL error, BOOL ask, NSURL *askURL);

@interface MCCAppRater : NSObject

/*!
 Builds a mutable dictionary suitable to send. You can add additional information if required before the send. Username will be hashed in this method. Returns nil if no username or databaseUUID is passed.
 */
+ (NSMutableDictionary *)standardArgumentsForCloudID:(NSString *)cloudID username:(NSString *)username databaseUUID:(NSString *)uuid firstUseDate:(NSString *)dateStr;


+ (ASIHTTPRequest *)askForRatingUsingArguments:(NSDictionary *)args callback:(MCCAppRaterCallback)callback;

@end
